/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.css.css.CssParser;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleMedia;
import org.w3c.css.parser.AtRulePage;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssFouffa;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssValidatorListener;
import org.w3c.css.parser.Errors;
import org.w3c.css.parser.analyzer.TokenMgrError;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

public final class StyleSheetParser
implements CssValidatorListener,
CssParser {
    private static Constructor co = null;
    CssFouffa cssFouffa;
    StyleSheet style = new StyleSheet();

    public void reInit() {
        this.style = new StyleSheet();
    }

    public StyleSheet getStyleSheet() {
        return this.style;
    }

    public void setWarningLevel(int warningLevel) {
        this.style.setWarningLevel(warningLevel);
    }

    public void notifyErrors(Errors errors) {
        this.style.addErrors(errors);
    }

    public void notifyWarnings(Warnings warnings) {
        this.style.addWarnings(warnings);
    }

    public void handleRule(ApplContext ac, CssSelectors selector, Vector properties) {
        if (selector.getAtRule() instanceof AtRulePage) {
            this.style.remove(selector);
        }
        Enumeration e2 = properties.elements();
        while (e2.hasMoreElements()) {
            CssProperty property = (CssProperty)e2.nextElement();
            property.setSelectors(selector);
            this.style.addProperty(selector, property);
        }
    }

    public void addCharSet(String charset) {
        this.style.addCharSet(charset);
    }

    public void newAtRule(AtRule atRule) {
        this.style.newAtRule(atRule);
    }

    public void endOfAtRule() {
        this.style.endOfAtRule();
    }

    public void setImportant(boolean important) {
        this.style.setImportant(important);
    }

    public void setSelectorList(Vector selectors) {
        this.style.setSelectorList(selectors);
    }

    public void setProperty(Vector properties) {
        this.style.setProperty(properties);
    }

    public void endOfRule() {
        this.style.endOfRule();
    }

    public void removeThisRule() {
        this.style.removeThisRule();
    }

    public void removeThisAtRule() {
        this.style.removeThisAtRule();
    }

    public void handleAtRule(ApplContext ac, String ident, String string) {
        this.style.getWarnings().addWarning(new Warning(this.cssFouffa.getSourceFile(), this.cssFouffa.getLine(), "at-rule", 2, new String[]{ident, string}, ac));
    }

    public void parseURL(ApplContext ac, URL url, String title, String kind, String media, int origin) {
        this.setWarningLevel(ac.getWarningLevel());
        if (Util.onDebug) {
            System.err.println("StyleSheet.parseURL(" + url + ", " + title + ", " + kind + ", " + media + ", " + origin + ")");
        }
        if (kind != null && !(kind = kind.trim().toLowerCase()).equals("stylesheet") && !kind.equals("alternate stylesheet")) {
            return;
        }
        try {
            ac.setOrigin(origin);
            this.cssFouffa = new CssFouffa(ac, url);
            this.cssFouffa.addListener(this);
            if (media == null) {
                media = ac.getMedium() == null ? "all" : ac.getMedium();
            }
            AtRuleMedia m = new AtRuleMedia();
            try {
                this.addMedias(m, media, ac);
                this.cssFouffa.setAtRule(m);
            }
            catch (InvalidParamException e) {
                Errors er = new Errors();
                er.addError(new CssError(url.toString(), -1, e));
                this.notifyErrors(er);
                return;
            }
            this.cssFouffa.parseStyle();
        }
        catch (Exception e) {
            Errors er = new Errors();
            er.addError(new CssError(url.toString(), -1, e));
            this.notifyErrors(er);
        }
    }

    private void addMedias(AtRuleMedia m, String medias, ApplContext ac) throws InvalidParamException {
        StringTokenizer tokens = new StringTokenizer(medias, ",");
        while (tokens.hasMoreTokens()) {
            m.addMedia(tokens.nextToken().trim(), ac);
        }
    }

    public void parseStyleElement(ApplContext ac, InputStream input, String title, String media, URL url, int lineno) {
        this.style.setWarningLevel(ac.getWarningLevel());
        if (Util.onDebug) {
            System.err.println("StyleSheet.parseStyleElement(" + title + ", " + media + ", " + url + "," + lineno + ")");
        }
        try {
            this.cssFouffa = new CssFouffa(ac, input, url, lineno);
            this.cssFouffa.addListener(this);
            if (media == null) {
                media = "all";
            }
            AtRuleMedia m = new AtRuleMedia();
            try {
                this.addMedias(m, media, ac);
                this.cssFouffa.setAtRule(m);
            }
            catch (InvalidParamException e) {
                Errors er = new Errors();
                er.addError(new CssError(url.toString(), -1, e));
                this.notifyErrors(er);
                return;
            }
            this.cssFouffa.parseStyle();
        }
        catch (IOException e) {
            Errors er = new Errors();
            er.addError(new CssError(url.toString(), -1, e));
            this.notifyErrors(er);
        }
        catch (TokenMgrError e) {
            Errors er = new Errors();
            CssParseException cpe = null;
            if (co != null) {
                try {
                    Object[] o = new Object[]{e};
                    Exception new_e = (Exception)co.newInstance(o);
                    cpe = new CssParseException(new_e);
                }
                catch (Exception ex) {
                    cpe = null;
                }
            }
            if (cpe == null) {
                cpe = new CssParseException(new Exception(e.getMessage()));
            }
            er.addError(new CssError(url.toString(), e.getErrorLine(), cpe));
            this.notifyErrors(er);
        }
        catch (RuntimeException e) {
            Errors er = new Errors();
            er.addError(new CssError(url.toString(), this.cssFouffa.getLine(), new CssParseException(e)));
            this.notifyErrors(er);
        }
    }

    public void parseStyleElement(ApplContext ac, String input, URL url, int lineno) {
        this.parseStyleElement(ac, new ByteArrayInputStream(input.getBytes()), null, null, url, lineno);
    }

    public void parseStyleAttribute(ApplContext ac, InputStream input, String id, URL url, int lineno) {
        this.style.setWarningLevel(ac.getWarningLevel());
        --lineno;
        if (Util.onDebug) {
            System.err.println("StyleSheet.parseStyleAttribute(" + id + "," + url + "," + lineno + ")");
        }
        try {
            this.cssFouffa = new CssFouffa(ac, input, url, lineno);
            this.cssFouffa.addListener(this);
            CssSelectors selector = new CssSelectors(ac);
            try {
                AtRuleMedia media = new AtRuleMedia();
                media.addMedia("all", ac);
                this.cssFouffa.setAtRule(media);
            }
            catch (InvalidParamException e) {
                // empty catch block
            }
            try {
                selector.addId(new IdSelector(id.substring(1)));
            }
            catch (InvalidParamException e) {
                this.style.removeThisRule();
                ac.getFrame().addError(new CssError(e));
            }
            this.cssFouffa.parseDeclarations(selector);
        }
        catch (IOException e) {
            Errors er = new Errors();
            er.addError(new CssError(url.toString(), -1, e));
            this.notifyErrors(er);
        }
    }

    public void parseStyleAttribute(ApplContext ac, String input, String id, URL url, int lineno) {
        this.parseStyleAttribute(ac, new ByteArrayInputStream(input.getBytes()), id, url, lineno);
    }

    public void setStyle(Class style) {
        this.cssFouffa.setStyle(style);
    }

    static {
        try {
            Class<Exception> c = Exception.class;
            Class[] cp = new Class[]{Exception.class};
            co = c.getDeclaredConstructor(cp);
        }
        catch (NoSuchMethodException ex) {
            co = null;
        }
    }
}

